import { allPosts } from 'contentlayer/generated';
import { notFound } from 'next/navigation';
import { PostLayout } from '../../../components/PostLayout';

export const generateStaticParams = () => allPosts.map((p) => ({ slug: p.slug }));

export default function PostPage({ params }: { params: { slug: string } }) {
  const post = allPosts.find((p) => p.slug === params.slug);
  if (!post) return notFound();
  return <PostLayout post={post} />;
}